-- Function to determine the energy impacts for a measure run entry using WEIGHTED results data
-- 
-- the measure_id (as it exists in the measure_runs table) is passed to this function
-- results are first deleted (from meas_impacts_wtd) for the measure_id
-- missing data are reported in the missing_sim table; which should be emptied to see only latest missing data
-- impacts are rounded to three significant figures and are inserted into the meas_impacts_wtd table
DECLARE
    MeasRunsRec "support"."measure_matrix_ip"%ROWTYPE;
    MsrResRec "simresults"."tech_results_wtd"%ROWTYPE;
    StdResRec "simresults"."tech_results_wtd"%ROWTYPE;
    PreResRec "simresults"."tech_results_wtd"%ROWTYPE;
    IPResRec  "simresults"."tech_results_wtd"%ROWTYPE;
    MeasImpRec  "simresults"."meas_impacts_wtd"%ROWTYPE;
    NumRecs INTEGER;
    TotProc INTEGER; 
    numunits FLOAT;
    apre_kwh_tot FLOAT;
    apre_kwh_ltg FLOAT;
    apre_kwh_task FLOAT;
    apre_kwh_equip FLOAT;
    apre_kwh_htg FLOAT;
    apre_kwh_clg FLOAT;
    apre_kwh_twr FLOAT;
    apre_kwh_aux FLOAT;
    apre_kwh_vent FLOAT;
    apre_kwh_venthtg FLOAT;
    apre_kwh_ventclg FLOAT;
    apre_kwh_refg FLOAT;
    apre_kwh_hpsup FLOAT;
    apre_kwh_shw FLOAT;
    apre_kwh_ext FLOAT;
    apre_thm_tot FLOAT;
    apre_thm_equip FLOAT;
    apre_thm_htg FLOAT;
    apre_thm_shw FLOAT;
    apre_kwpp_tot FLOAT;
    apre_kwpp_ltg FLOAT;
    apre_kwpp_equip FLOAT;
    astd_kwh_tot FLOAT;
    astd_kwh_ltg FLOAT;
    astd_kwh_task FLOAT;
    astd_kwh_equip FLOAT;
    astd_kwh_htg FLOAT;
    astd_kwh_clg FLOAT;
    astd_kwh_twr FLOAT;
    astd_kwh_aux FLOAT;
    astd_kwh_vent FLOAT;
    astd_kwh_venthtg FLOAT;
    astd_kwh_ventclg FLOAT;
    astd_kwh_refg FLOAT;
    astd_kwh_hpsup FLOAT;
    astd_kwh_shw FLOAT;
    astd_kwh_ext FLOAT;
    astd_thm_tot FLOAT;
    astd_thm_equip FLOAT;
    astd_thm_htg FLOAT;
    astd_thm_shw FLOAT;
    astd_kwpp_tot FLOAT;
    astd_kwpp_ltg FLOAT;
    astd_kwpp_equip FLOAT;
    base_techid TEXT;

BEGIN
 TotProc = 0;
 -- Delete any existing result for the qualifying records
 --DELETE FROM simresults.meas_impacts_wtd WHERE measure_id = $1;
 --DELETE FROM simresults.missing_sim WHERE measure_id = $1;
 -- Loop thru every intended applicability of the measure:
 FOR MeasRunsRec IN SELECT * FROM support.measure_matrix_ip 
  WHERE tstat = 1 
   -- AND bldgtype in('MFm','DMo')
  AND "MeasureID" = $1
  LOOP
   TotProc = TotProc + 1;
   -- clear previous results
    apre_kwh_tot = 0;
    apre_kwh_ltg = 0;
    apre_kwh_task = 0;
    apre_kwh_equip = 0;
    apre_kwh_htg = 0;
    apre_kwh_clg = 0;
    apre_kwh_twr = 0;
    apre_kwh_aux = 0;
    apre_kwh_vent = 0;
    apre_kwh_venthtg = 0;
    apre_kwh_ventclg = 0;
    apre_kwh_refg = 0;
    apre_kwh_hpsup = 0;
    apre_kwh_shw = 0;
    apre_kwh_ext = 0;
    apre_thm_tot = 0;
    apre_thm_equip = 0;
    apre_thm_htg = 0;
    apre_thm_shw = 0;
    apre_kwpp_tot = 0;
    apre_kwpp_ltg = 0;
    apre_kwpp_equip = 0;
    astd_kwh_tot = 0;
    astd_kwh_ltg = 0;
    astd_kwh_task = 0;
    astd_kwh_equip = 0;
    astd_kwh_htg = 0;
    astd_kwh_clg = 0;
    astd_kwh_twr = 0;
    astd_kwh_aux = 0;
    astd_kwh_vent = 0;
    astd_kwh_venthtg = 0;
    astd_kwh_ventclg = 0;
    astd_kwh_refg = 0;
    astd_kwh_hpsup = 0;
    astd_kwh_shw = 0;
    astd_kwh_ext = 0;
    astd_thm_tot = 0;
    astd_thm_equip = 0;
    astd_thm_htg = 0;
    astd_thm_shw = 0;
    astd_kwpp_tot = 0;
    astd_kwpp_ltg = 0;
    astd_kwpp_equip = 0;
    base_techid = 'NotSet';
   -- Get the Measure tech results:
   SELECT * INTO MsrResRec from simresults.tech_results_wtd
     WHERE  techrefid = MeasRunsRec."MsrTechID"
       and  simqual   = MeasRunsRec."MsrSimQual"
       and  bldgtype  = MeasRunsRec.bldgtype
       and  bldgvint  = MeasRunsRec.bldgvint  
       and  bldgloc   = MeasRunsRec.bldgloc
       and  bldghvac  = MeasRunsRec.bldghvac
       and  tstat     = -1;
   IF NOT FOUND THEN
    INSERT INTO simresults.missing_sim VALUES (MeasRunsRec."MeasureID",MeasRunsRec."MsrTechID",MeasRunsRec."MsrSimQual",'Msr',MeasRunsRec.bldgtype,MeasRunsRec.bldgvint,MeasRunsRec.bldgloc,MeasRunsRec.bldghvac,-1);
      -- RAISE NOTICE 'no tech results found for %', MeasRunsRec."MeasureID"||':'||MeasRunsRec."MsrTechID";
    CONTINUE;
   END IF;
    -- Get the Pre-Existing tech results:
   IF MeasRunsRec."PreTechID" IS NOT NULL THEN
    base_techid = MeasRunsRec."PreTechID";
    IF MeasRunsRec."PreTechID" = 'IP' THEN
     -- Get pre-existing results from Initialized Prototype results:
     SELECT * INTO PreResRec from simresults.tech_results_wtd
      WHERE  techrefid = 'IP' 
        and  simqual   = 'None'
        and  bldgtype  = MeasRunsRec.bldgtype
        and  bldgvint  = MeasRunsRec.bldgvint  
        and  bldgloc   = MeasRunsRec.bldgloc
        and  bldghvac  = MeasRunsRec.bldghvac
        and  tstat     = -1;
      IF NOT FOUND THEN
       INSERT INTO simresults.missing_sim VALUES (MeasRunsRec."MeasureID",'IP','None','Pre',MeasRunsRec.bldgtype,MeasRunsRec.bldgvint,MeasRunsRec.bldgloc,MeasRunsRec.bldghvac,-1);
         --RAISE EXCEPTION 'no Initialized Prototype results found for %', MeasRunsRec.techrefid||':'||MeasRunsRec.bldgtype;
       CONTINUE;
      END IF;
    ELSE
     -- Get pre-existing results from Tech Results:
     SELECT * INTO PreResRec from simresults.tech_results_wtd
      WHERE  techrefid = MeasRunsRec."PreTechID"
        and  simqual   = MeasRunsRec."PreSimQual"
        and  bldgtype  = MeasRunsRec.bldgtype
        and  bldgvint  = MeasRunsRec.bldgvint  
        and  bldgloc   = MeasRunsRec.bldgloc
        and  bldghvac  = MeasRunsRec.bldghvac
        and  tstat     = -1;
      IF NOT FOUND THEN
       INSERT INTO simresults.missing_sim VALUES (MeasRunsRec."MeasureID",MeasRunsRec."PreTechID",MeasRunsRec."PreSimQual",'Pre',MeasRunsRec.bldgtype,MeasRunsRec.bldgvint,MeasRunsRec.bldgloc,MeasRunsRec.bldghvac,-1);
         -- RAISE EXCEPTION 'no pre-existing tech results found for %', MeasRunsRec.measure_id||':'||MeasRunsRec.pre_refid;
       CONTINUE;
      END IF;
     END IF; -- of IF PreTechID = 'IP' 
     numunits = MsrResRec.numunits;
     apre_kwh_tot     = (PreResRec.kwh_tot     - MsrResRec.kwh_tot)/numunits;
     apre_kwh_ltg     = (PreResRec.kwh_ltg     - MsrResRec.kwh_ltg)/numunits;
     apre_kwh_task    = (PreResRec.kwh_task    - MsrResRec.kwh_task)/numunits;
     apre_kwh_equip   = (PreResRec.kwh_equip   - MsrResRec.kwh_equip)/numunits;
     apre_kwh_htg     = (PreResRec.kwh_htg     - MsrResRec.kwh_htg)/numunits;
     apre_kwh_clg     = (PreResRec.kwh_clg     - MsrResRec.kwh_clg)/numunits;
     apre_kwh_twr     = (PreResRec.kwh_twr     - MsrResRec.kwh_twr)/numunits;
     apre_kwh_aux     = (PreResRec.kwh_aux     - MsrResRec.kwh_aux)/numunits;
     apre_kwh_vent    = (PreResRec.kwh_vent    - MsrResRec.kwh_vent)/numunits;
     apre_kwh_venthtg = (PreResRec.kwh_venthtg - MsrResRec.kwh_venthtg)/numunits;
     apre_kwh_ventclg = (PreResRec.kwh_ventclg - MsrResRec.kwh_ventclg)/numunits;
     apre_kwh_refg    = (PreResRec.kwh_refg    - MsrResRec.kwh_refg)/numunits;
     apre_kwh_hpsup   = (PreResRec.kwh_hpsup   - MsrResRec.kwh_hpsup)/numunits;
     apre_kwh_shw     = (PreResRec.kwh_shw     - MsrResRec.kwh_shw)/numunits;
     apre_kwh_ext     = (PreResRec.kwh_ext     - MsrResRec.kwh_ext)/numunits;
     apre_thm_tot     = (PreResRec.thm_tot     - MsrResRec.thm_tot)/numunits;
     apre_thm_equip   = (PreResRec.thm_equip   - MsrResRec.thm_equip)/numunits;
     apre_thm_htg     = (PreResRec.thm_htg     - MsrResRec.thm_htg)/numunits;
     apre_thm_shw     = (PreResRec.thm_shw     - MsrResRec.thm_shw)/numunits;
     apre_kwpp_tot    = (PreResRec.kwpp_tot    - MsrResRec.kwpp_tot)/numunits;
     apre_kwpp_ltg    = (PreResRec.kwpp_ltg    - MsrResRec.kwpp_ltg)/numunits;
     apre_kwpp_equip  = (PreResRec.kwpp_equip  - MsrResRec.kwpp_equip)/numunits;
   END IF; -- of IF PreTechID NOT NULL

   IF MeasRunsRec."StdTechID" IS NOT NULL THEN
    -- if the base_techid has not been set yet, then this is the base_techid (no pre-existing case for this measure)
    If base_techid = 'NotSet' then base_techid = MeasRunsRec."StdTechID"; End IF;
    IF MeasRunsRec."StdTechID" = 'IP' THEN
     -- Get standard results from Initialized Prototype results:
     SELECT * INTO StdResRec from simresults.tech_results_wtd
      WHERE  techrefid = 'IP' 
        and  simqual   = 'None'
        and  bldgtype  = MeasRunsRec.bldgtype
        and  bldgvint  = MeasRunsRec.bldgvint  
        and  bldgloc   = MeasRunsRec.bldgloc
        and  bldghvac  = MeasRunsRec.bldghvac
        and  tstat     = -1;
      IF NOT FOUND THEN
       INSERT INTO simresults.missing_sim VALUES (MeasRunsRec."MeasureID",'IP','None','Std',MeasRunsRec.bldgtype,MeasRunsRec.bldgvint,MeasRunsRec.bldgloc,MeasRunsRec.bldghvac,-1);
         --RAISE EXCEPTION 'no Initialized Prototype results found for %', MeasRunsRec.measure_id||':'||MeasRunsRec.pre_refid;
       CONTINUE;
      END IF;
    ELSE
    -- Get Code/Standard results from Tech Results (I don't think it's ever from IP results):
     SELECT * INTO StdResRec from simresults.tech_results_wtd
      WHERE  techrefid = MeasRunsRec."StdTechID"
        and  simqual   = MeasRunsRec."StdSimQual"
        and  bldgtype  = MeasRunsRec.bldgtype
        and  bldgvint  = MeasRunsRec.bldgvint  
        and  bldgloc   = MeasRunsRec.bldgloc
        and  bldghvac  = MeasRunsRec.bldghvac
        and  tstat     = -1;
     IF NOT FOUND THEN
      INSERT INTO simresults.missing_sim VALUES (MeasRunsRec."MeasureID",MeasRunsRec."StdTechID",MeasRunsRec."StdSimQual",'Std',MeasRunsRec.bldgtype,MeasRunsRec.bldgvint,MeasRunsRec.bldgloc,MeasRunsRec.bldghvac,-1);
      --RAISE EXCEPTION 'no code/standard results found for %', MeasRunsRec.||':'||MeasRunsRec.std_refid;
      CONTINUE;
     END IF;
    END IF; -- of IF StdTechID = 'IP' 
     numunits = MsrResRec.numunits;
     astd_kwh_tot     = (StdResRec.kwh_tot     - MsrResRec.kwh_tot)/numunits;
     astd_kwh_ltg     = (StdResRec.kwh_ltg     - MsrResRec.kwh_ltg)/numunits;
     astd_kwh_task    = (StdResRec.kwh_task    - MsrResRec.kwh_task)/numunits;
     astd_kwh_equip   = (StdResRec.kwh_equip   - MsrResRec.kwh_equip)/numunits;
     astd_kwh_htg     = (StdResRec.kwh_htg     - MsrResRec.kwh_htg)/numunits;
     astd_kwh_clg     = (StdResRec.kwh_clg     - MsrResRec.kwh_clg)/numunits;
     astd_kwh_twr     = (StdResRec.kwh_twr     - MsrResRec.kwh_twr)/numunits;
     astd_kwh_aux     = (StdResRec.kwh_aux     - MsrResRec.kwh_aux)/numunits;
     astd_kwh_vent    = (StdResRec.kwh_vent    - MsrResRec.kwh_vent)/numunits;
     astd_kwh_venthtg = (StdResRec.kwh_venthtg - MsrResRec.kwh_venthtg)/numunits;
     astd_kwh_ventclg = (StdResRec.kwh_ventclg - MsrResRec.kwh_ventclg)/numunits;
     astd_kwh_refg    = (StdResRec.kwh_refg    - MsrResRec.kwh_refg)/numunits;
     astd_kwh_hpsup   = (StdResRec.kwh_hpsup   - MsrResRec.kwh_hpsup)/numunits;
     astd_kwh_shw     = (StdResRec.kwh_shw     - MsrResRec.kwh_shw)/numunits;
     astd_kwh_ext     = (StdResRec.kwh_ext     - MsrResRec.kwh_ext)/numunits;
     astd_thm_tot     = (StdResRec.thm_tot     - MsrResRec.thm_tot)/numunits;
     astd_thm_equip   = (StdResRec.thm_equip   - MsrResRec.thm_equip)/numunits;
     astd_thm_htg     = (StdResRec.thm_htg     - MsrResRec.thm_htg)/numunits;
     astd_thm_shw     = (StdResRec.thm_shw     - MsrResRec.thm_shw)/numunits;
     astd_kwpp_tot    = (StdResRec.kwpp_tot    - MsrResRec.kwpp_tot)/numunits;
     astd_kwpp_ltg    = (StdResRec.kwpp_ltg    - MsrResRec.kwpp_ltg)/numunits;
     astd_kwpp_equip  = (StdResRec.kwpp_equip  - MsrResRec.kwpp_equip)/numunits;
   END IF;

   -- Copy the impacts into the Measure Impacts table  
   INSERT INTO simresults.meas_impacts_wtd VALUES 
         (DEFAULT,
          MeasRunsRec."MeasureID",
          MeasRunsRec.bldgtype,
          MeasRunsRec.bldgvint, 
          MeasRunsRec.bldgloc, 
          MeasRunsRec.bldghvac,
          -1,
          MsrResRec.normunit,
          MsrResRec.numunits,
          MsrResRec.measarea,
          -- above pre-existing impacts:
          case when apre_kwh_tot     = 0 then 0 else round(apre_kwh_tot::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_tot))))::INT) end, 
          case when apre_kwh_ltg     = 0 then 0 else round(apre_kwh_ltg::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_ltg))))::INT) end, 
          case when apre_kwh_task    = 0 then 0 else round(apre_kwh_task::NUMERIC(15,3)   ,(2-floor(log(abs(apre_kwh_task))))::INT) end, 
          case when apre_kwh_equip   = 0 then 0 else round(apre_kwh_equip::NUMERIC(15,3)  ,(2-floor(log(abs(apre_kwh_equip))))::INT) end, 
          case when apre_kwh_htg     = 0 then 0 else round(apre_kwh_htg::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_htg))))::INT) end, 
          case when apre_kwh_clg     = 0 then 0 else round(apre_kwh_clg::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_clg))))::INT) end, 
          case when apre_kwh_twr     = 0 then 0 else round(apre_kwh_twr::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_twr))))::INT) end, 
          case when apre_kwh_aux     = 0 then 0 else round(apre_kwh_aux::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_aux))))::INT) end, 
          case when apre_kwh_vent    = 0 then 0 else round(apre_kwh_vent::NUMERIC(15,3)   ,(2-floor(log(abs(apre_kwh_vent))))::INT) end, 
          case when apre_kwh_venthtg = 0 then 0 else round(apre_kwh_venthtg::NUMERIC(15,3),(2-floor(log(abs(apre_kwh_venthtg))))::INT) end, 
          case when apre_kwh_ventclg = 0 then 0 else round(apre_kwh_ventclg::NUMERIC(15,3),(2-floor(log(abs(apre_kwh_ventclg))))::INT) end, 
          case when apre_kwh_refg    = 0 then 0 else round(apre_kwh_refg::NUMERIC(15,3)   ,(2-floor(log(abs(apre_kwh_refg))))::INT) end, 
          case when apre_kwh_hpsup   = 0 then 0 else round(apre_kwh_hpsup::NUMERIC(15,3)  ,(2-floor(log(abs(apre_kwh_hpsup))))::INT) end, 
          case when apre_kwh_shw     = 0 then 0 else round(apre_kwh_shw::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_shw))))::INT) end, 
          case when apre_kwh_ext     = 0 then 0 else round(apre_kwh_ext::NUMERIC(15,3)    ,(2-floor(log(abs(apre_kwh_ext))))::INT) end, 
          case when apre_thm_tot     = 0 then 0 else round(apre_thm_tot::NUMERIC(15,3)    ,(2-floor(log(abs(apre_thm_tot))))::INT) end, 
          case when apre_thm_equip   = 0 then 0 else round(apre_thm_equip::NUMERIC(15,3)  ,(2-floor(log(abs(apre_thm_equip))))::INT) end, 
          case when apre_thm_htg     = 0 then 0 else round(apre_thm_htg::NUMERIC(15,3)    ,(2-floor(log(abs(apre_thm_htg))))::INT) end, 
          case when apre_thm_shw     = 0 then 0 else round(apre_thm_shw::NUMERIC(15,3)    ,(2-floor(log(abs(apre_thm_shw))))::INT) end, 
          case when apre_kwpp_tot    = 0 then 0 else round(apre_kwpp_tot::NUMERIC(15,6)   ,(2-floor(log(abs(apre_kwpp_tot))))::INT) end, 
          case when apre_kwpp_ltg    = 0 then 0 else round(apre_kwpp_ltg::NUMERIC(15,6)   ,(2-floor(log(abs(apre_kwpp_ltg))))::INT) end, 
          case when apre_kwpp_equip  = 0 then 0 else round(apre_kwpp_equip::NUMERIC(15,6) ,(2-floor(log(abs(apre_kwpp_equip))))::INT) end, 
          -- above standard/code impacts:
          case when astd_kwh_tot     = 0 then 0 else round(astd_kwh_tot::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_tot))))::INT) end, 
          case when astd_kwh_ltg     = 0 then 0 else round(astd_kwh_ltg::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_ltg))))::INT) end, 
          case when astd_kwh_task    = 0 then 0 else round(astd_kwh_task::NUMERIC(15,3)   ,(2-floor(log(abs(astd_kwh_task))))::INT) end, 
          case when astd_kwh_equip   = 0 then 0 else round(astd_kwh_equip::NUMERIC(15,3)  ,(2-floor(log(abs(astd_kwh_equip))))::INT) end, 
          case when astd_kwh_htg     = 0 then 0 else round(astd_kwh_htg::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_htg))))::INT) end, 
          case when astd_kwh_clg     = 0 then 0 else round(astd_kwh_clg::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_clg))))::INT) end, 
          case when astd_kwh_twr     = 0 then 0 else round(astd_kwh_twr::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_twr))))::INT) end, 
          case when astd_kwh_aux     = 0 then 0 else round(astd_kwh_aux::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_aux))))::INT) end, 
          case when astd_kwh_vent    = 0 then 0 else round(astd_kwh_vent::NUMERIC(15,3)   ,(2-floor(log(abs(astd_kwh_vent))))::INT) end, 
          case when astd_kwh_venthtg = 0 then 0 else round(astd_kwh_venthtg::NUMERIC(15,3),(2-floor(log(abs(astd_kwh_venthtg))))::INT) end, 
          case when astd_kwh_ventclg = 0 then 0 else round(astd_kwh_ventclg::NUMERIC(15,3),(2-floor(log(abs(astd_kwh_ventclg))))::INT) end, 
          case when astd_kwh_refg    = 0 then 0 else round(astd_kwh_refg::NUMERIC(15,3)   ,(2-floor(log(abs(astd_kwh_refg))))::INT) end, 
          case when astd_kwh_hpsup   = 0 then 0 else round(astd_kwh_hpsup::NUMERIC(15,3)  ,(2-floor(log(abs(astd_kwh_hpsup))))::INT) end, 
          case when astd_kwh_shw     = 0 then 0 else round(astd_kwh_shw::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_shw))))::INT) end, 
          case when astd_kwh_ext     = 0 then 0 else round(astd_kwh_ext::NUMERIC(15,3)    ,(2-floor(log(abs(astd_kwh_ext))))::INT) end, 
          case when astd_thm_tot     = 0 then 0 else round(astd_thm_tot::NUMERIC(15,3)    ,(2-floor(log(abs(astd_thm_tot))))::INT) end, 
          case when astd_thm_equip   = 0 then 0 else round(astd_thm_equip::NUMERIC(15,3)  ,(2-floor(log(abs(astd_thm_equip))))::INT) end, 
          case when astd_thm_htg     = 0 then 0 else round(astd_thm_htg::NUMERIC(15,3)    ,(2-floor(log(abs(astd_thm_htg))))::INT) end, 
          case when astd_thm_shw     = 0 then 0 else round(astd_thm_shw::NUMERIC(15,3)    ,(2-floor(log(abs(astd_thm_shw))))::INT) end, 
          case when astd_kwpp_tot    = 0 then 0 else round(astd_kwpp_tot::NUMERIC(15,6)   ,(2-floor(log(abs(astd_kwpp_tot))))::INT) end, 
          case when astd_kwpp_ltg    = 0 then 0 else round(astd_kwpp_ltg::NUMERIC(15,6)   ,(2-floor(log(abs(astd_kwpp_ltg))))::INT) end, 
          case when astd_kwpp_equip  = 0 then 0 else round(astd_kwpp_equip::NUMERIC(15,6) ,(2-floor(log(abs(astd_kwpp_equip))))::INT) end,
          base_techid
          );
  END LOOP;
 RETURN TotProc;
END;
